/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing.dev;

import frc.emul.api.ui.IDisplay;
import frc.emul.periph.Analog;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.opengl.Display;
import frc.emul.vectrex.ui.opengl.JoglContext;
import frc.emul.vectrex.ui.opengl.JoglListenerBlur;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIGfxItemLimiter {
    private static JDialog dialog;

    public static final void openSettingsEditor(JFrame jFrame, IDisplay iDisplay) {
        if (dialog != null) {
            dialog.requestFocus();
            return;
        }
        Display display = (Display)iDisplay;
        final JoglListenerBlur joglListenerBlur = (JoglListenerBlur)display.getRenderer();
        final JoglContext joglContext = joglListenerBlur.getContext();
        final GLAutoDrawable gLAutoDrawable = display.getDrawable();
        final JDialog jDialog = new JDialog(jFrame, "ParaJVE - Rendering Tweaking", false);
        JButton jButton = new JButton("Close");
        final JSlider jSlider = new JSlider(-1, 2000, joglListenerBlur.getMaxItemsDrawn());
        final JSlider jSlider2 = new JSlider(0, 1000, (int)(100.0f * joglContext.getPointsSize()));
        final JSlider jSlider3 = new JSlider(0, 1000, (int)(100.0f * joglContext.getLinesSize()));
        final JSpinnerFix jSpinnerFix = new JSpinnerFix(new SpinnerNumberModel((double)jSlider.getValue(), (double)jSlider.getMinimum(), (double)jSlider.getMaximum(), 1.0));
        final JSpinnerFix jSpinnerFix2 = new JSpinnerFix(new SpinnerNumberModel((double)jSlider2.getValue() / 100.0, (double)jSlider2.getMinimum() / 100.0, (double)jSlider2.getMaximum() / 100.0, 0.1));
        final JSpinnerFix jSpinnerFix3 = new JSpinnerFix(new SpinnerNumberModel((double)jSlider3.getValue() / 100.0, (double)jSlider3.getMinimum() / 100.0, (double)jSlider3.getMaximum() / 100.0, 0.1));
        final Analog analog = Analog.INSTANCE;
        final JSlider jSlider4 = new JSlider(-8000, 8000, (int)(100.0f * analog.ramp_delay1));
        final JSlider jSlider5 = new JSlider(-8000, 8000, (int)(100.0f * analog.ramp_delay2));
        final JSpinnerFix jSpinnerFix4 = new JSpinnerFix(new SpinnerNumberModel((double)jSlider4.getValue() / 100.0, (double)jSlider4.getMinimum() / 100.0, (double)jSlider4.getMaximum() / 100.0, 0.1));
        final JSpinnerFix jSpinnerFix5 = new JSpinnerFix(new SpinnerNumberModel((double)jSlider5.getValue() / 100.0, (double)jSlider5.getMinimum() / 100.0, (double)jSlider5.getMaximum() / 100.0, 0.1));
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 0, 10), Borders.BEVEL_LOW_10));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix.setValue(new Integer(jSlider.getValue()));
            }
        });
        jSpinnerFix.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)jSpinnerFix.getValue();
                jSlider.setValue(n);
                if (n != joglListenerBlur.getMaxItemsDrawn()) {
                    joglListenerBlur.setMaxItemsDrawn(n);
                    gLAutoDrawable.repaint();
                }
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix2.setValue((double)new Integer(jSlider2.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix2.getValue()).floatValue();
                jSlider2.setValue((int)(f * 100.0f));
                if (f != joglContext.getPointsSize()) {
                    joglContext.setPointsSize(f);
                    gLAutoDrawable.repaint();
                }
            }
        });
        jSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix3.setValue((double)new Integer(jSlider3.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix3.getValue()).floatValue();
                jSlider3.setValue((int)(f * 100.0f));
                if (f != joglContext.getLinesSize()) {
                    joglContext.setLinesSize(f);
                    gLAutoDrawable.repaint();
                }
            }
        });
        jSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix4.setValue((double)new Integer(jSlider4.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix4.getValue()).floatValue();
                jSlider4.setValue((int)(f * 100.0f));
                analog.ramp_delay1 = f;
            }
        });
        jSlider5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix5.setValue((double)new Integer(jSlider5.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix5.getValue()).floatValue();
                jSlider5.setValue((int)(f * 100.0f));
                analog.ramp_delay2 = f;
            }
        });
        jPanel.add(new JLabel("Items Limiter :"));
        jPanel.add(jSlider);
        jPanel.add(jSpinnerFix);
        jPanel.add(new JLabel("Points Size :"));
        jPanel.add(jSlider2);
        jPanel.add(jSpinnerFix2);
        jPanel.add(new JLabel("Lines Width :"));
        jPanel.add(jSlider3);
        jPanel.add(jSpinnerFix3);
        jPanel.add(new JLabel("Ramp Delay #1 :"));
        jPanel.add(jSlider4);
        jPanel.add(jSpinnerFix4);
        jPanel.add(new JLabel("Ramp Delay #2 :"));
        jPanel.add(jSlider5);
        jPanel.add(jSpinnerFix5);
        UIUtils.makeCompactGrid(jPanel, 5, 3, 0, 0, 6, 4);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add(jButton);
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog = null;
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jDialog.setDefaultCloseOperation(0);
        jDialog.getContentPane().add(jPanel3);
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        dialog = jDialog;
        jDialog.setVisible(true);
    }
}

